/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSGenericConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5321;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import net.minecraft.class_6880;
import net.minecraft.class_7059;

public class GenericJigsawStructure<C extends RSGenericConfig>
extends AbstractBaseStructure<C> {
    public GenericJigsawStructure(Codec<C> codec) {
        super(codec, GenericJigsawStructure::isGenericFeatureChunk, GenericJigsawStructure::generateGenericPieces);
    }

    public GenericJigsawStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSGenericConfig> boolean isGenericFeatureChunk(class_6834.class_6835<CC> context) {
        class_1923 chunkPos = context.comp_309();
        RSGenericConfig config = (RSGenericConfig)context.comp_310();
        if (!(context.comp_307() instanceof class_1973)) {
            for (int curChunkX = chunkPos.field_9181 - config.biomeRadius; curChunkX <= chunkPos.field_9181 + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - config.biomeRadius; curChunkZ <= chunkPos.field_9180 + config.biomeRadius; ++curChunkZ) {
                    int yValue = config.doNotUseHeightmap ? config.setFixedYSpawn : config.setFixedYSpawn + context.comp_306().method_20402(curChunkX << 4, curChunkZ << 4, class_2902.class_2903.field_13194, context.comp_311());
                    class_6880 biome = context.comp_307().method_38109(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.comp_306().method_38276());
                    if (context.comp_312().test(biome)) continue;
                    return false;
                }
            }
        }
        if (config.cannotSpawnInLiquid) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = context.comp_306().method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
            class_4966 columnOfBlocks = context.comp_306().method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_311());
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10264() + landHeight);
            if (!topBlock.method_26227().method_15769()) {
                return false;
            }
        }
        for (class_5321<class_7059> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.comp_306().method_41053(structureSetToAvoid, context.comp_308(), chunkPos.field_9181, chunkPos.field_9180, config.structureAvoidRadius)) continue;
            return false;
        }
        if (config.allowedTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = chunkPos.field_9181 - config.terrainHeightCheckRadius; curChunkX <= chunkPos.field_9181 + config.terrainHeightCheckRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - config.terrainHeightCheckRadius; curChunkZ <= chunkPos.field_9180 + config.terrainHeightCheckRadius; ++curChunkZ) {
                    int height = context.comp_306().method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, class_2902.class_2903.field_13194, context.comp_311());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= config.minYAllowed) continue;
                    return false;
                }
            }
            if (maxTerrainHeight - minTerrainHeight > config.allowedTerrainHeightRange) {
                return false;
            }
        }
        return true;
    }

    public static <CC extends RSGenericConfig> Optional<class_6622<CC>> generateGenericPieces(class_6834.class_6835<CC> context) {
        RSGenericConfig config = (RSGenericConfig)context.comp_310();
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), config.setFixedYSpawn, context.comp_309().method_8328());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), blockpos, !config.doNotUseHeightmap, !config.doNotUseHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((class_3790)pieces.get(0)).method_14922(0, config.centerYOffset, 0);
        });
    }
}

